using System;

namespace onlyconnect
{
	/// <summary>
	/// Event Handler classes for the HtmlEditor
	/// </summary>

	public delegate void HtmlNavigateEventHandler(Object s,
	HtmlNavigateEventArgs e);

	public class HtmlNavigateEventArgs
	{
		String target;

		public HtmlNavigateEventArgs(String target)
		{
			this.target = target;
		}

		public String Target
		{
			get { return target; }
		}
	}


	public class HtmlUpdateUIEventArgs : EventArgs
	{
		private mshtml.IHTMLElement mcurrentElement;
		public HtmlUpdateUIEventArgs(): base()
		{

		}

		public mshtml.IHTMLElement currentElement
		{
			get 
			{
				return mcurrentElement;
			}
			set 
			{
				mcurrentElement = value;
			}
		}
	}

	//declare the event handler
	public delegate void ReadyStateChangedHandler(object sender, ReadyStateChangedEventArgs e);

	//declare the event args

	public class ReadyStateChangedEventArgs : EventArgs 
	{
		private string mReadyState;
		public ReadyStateChangedEventArgs(string readystateVal) : base()
		{
			mReadyState = readystateVal;
		}

		public string ReadyState 
		{
			get 
			{
				return mReadyState;
			}
			//			set 
			//			{
			//				mReadyState = value;
			//			}
		}
		
	}

	//declare the update event handler
	public delegate void UpdateUIHandler(object sender, HtmlUpdateUIEventArgs e);


	//declare the keypress event handler
	public delegate void HtmlKeyPressHandler(object sender, HtmlKeyPressEventArgs e);

	//declare the event args

	public class HtmlKeyPressEventArgs : EventArgs 
	{
		private mshtml.IHTMLEventObj m_ev;
		public HtmlKeyPressEventArgs(ref  mshtml.IHTMLEventObj ev) : base()
		{
			m_ev = ev;
		}

		public mshtml.IHTMLEventObj HtmlEventObject
		{
			get 
			{
				return m_ev;
			}
		}
		
	}

	public delegate void HtmlEventHandler(Object s, HtmlEventArgs e);

	public class HtmlEventArgs
	{
		public mshtml.IHTMLEventObj Event;        
 
		public HtmlEventArgs(mshtml.IHTMLEventObj Event)
		{
			this.Event = Event;
		}
	}

}
